/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.music.player;

import dev.felnull.imp.client.music.player.IMusicPlayer;
import dev.felnull.imp.client.util.LavaPlayerUtil;
import dev.felnull.imp.client.util.SoundMath;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.format.AudioDataFormat;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.format.AudioDataFormatTools;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.format.AudioPlayerInputStream;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.player.AudioPlayer;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import dev.felnull.imp.music.MusicPlaybackInfo;
import dev.felnull.imp.music.resource.MusicSource;
import dev.felnull.imp.util.FlagThread;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.AL11;

public class LavaALMusicPlayer
implements IMusicPlayer {
    private static final Logger LOGGER = LogManager.getLogger(LavaALMusicPlayer.class);
    private static final Minecraft mc = Minecraft.m_91087_();
    protected final MusicSource musicSource;
    private final int source;
    protected final AudioPlayerManager audioPlayerManager;
    private final AudioDataFormat audioFormat;
    private final AudioPlayer audioPlayer;
    private final boolean spatial;
    private boolean stereo;
    protected AudioInputStream stream;
    private ByteBuffer pcm = BufferUtils.createByteBuffer((int)11025);
    private byte[] buffer = new byte[3072];
    private final List<Integer> buffers = new ArrayList<Integer>();
    private float ang;
    private int trig;
    private boolean loaded;
    private Vec3 pos = Vec3.f_82478_;
    private boolean fixed;
    private float range;
    private long startTime;
    protected long startPosition;
    private long lastPausedTime;
    private long pausedTime;
    private boolean firstStart;
    private double noSpatialVolume;
    private LavaLoadThread loadThread;
    private long lastLavaLoad;

    public LavaALMusicPlayer(MusicSource musicSource, AudioPlayerManager audioPlayerManager, AudioDataFormat audioFormat, boolean spatial) {
        this.musicSource = musicSource;
        this.source = AL11.alGenSources();
        this.audioPlayerManager = audioPlayerManager;
        this.audioFormat = audioFormat;
        this.audioPlayer = audioPlayerManager.createPlayer();
        this.spatial = spatial;
    }

    protected Optional<AudioTrack> createTrack() throws ExecutionException, InterruptedException {
        return LavaPlayerUtil.loadCashedTrack(this.musicSource.getLoaderType(), this.audioPlayerManager, this.musicSource.getIdentifier(), true);
    }

    @Override
    public void load(long position) throws Exception {
        this.startPosition = position;
        Optional<AudioTrack> track = this.createTrack();
        if (track.isEmpty()) {
            throw new IllegalStateException("Could not load");
        }
        track.get().setPosition(position);
        this.audioPlayer.startTrack(track.get(), false);
        this.stream = AudioPlayerInputStream.createStream(this.audioPlayer, this.audioFormat, this.audioFormat.frameDuration(), false);
        this.stereo = AudioDataFormatTools.toAudioFormat(this.audioFormat).getChannels() >= 2;
        AL11.alSourcef((int)this.source, (int)4099, (float)1.0f);
        AL11.alSourcei((int)this.source, (int)514, (int)0);
        AL11.alSourcei((int)this.source, (int)4103, (int)0);
        LavaALMusicPlayer.checkError();
        AudioFormat format = AudioDataFormatTools.toAudioFormat(this.audioFormat);
        for (int i = 0; i < 500; ++i) {
            try {
                if (this.stream.read(this.buffer) < 0) continue;
                this.lavaLoad(format);
                continue;
            }
            catch (InterruptedIOException ex) {
                return;
            }
        }
        this.loadThread = new LavaLoadThread();
        this.loadThread.start();
        this.loaded = true;
    }

    @Override
    public boolean isLoadSuccess() {
        return this.loaded;
    }

    @Override
    public void play(long delay) {
        if (!this.loaded) {
            return;
        }
        if (this.musicSource.isLive() || this.musicSource.getDuration() == 0L || this.musicSource.getDuration() >= this.startPosition) {
            this.startTime = System.currentTimeMillis();
            this.startPosition += delay;
            float secdelay = (float)delay / 1000.0f;
            if (!this.spatial) {
                AL11.alSourcef((int)this.source, (int)4106, (float)0.0f);
            }
            AL11.alSourcef((int)this.source, (int)4132, (float)secdelay);
            AL11.alSourcePlay((int)this.source);
            this.firstStart = true;
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public void destroy() {
        if (this.loadThread != null) {
            this.loadThread.stopped();
        }
        this.startTime = 0L;
        this.startPosition = 0L;
        if (this.stream != null) {
            try {
                this.stream.close();
            }
            catch (IOException var2) {
                LOGGER.error("Failed to close audio stream", (Throwable)var2);
            }
            this.stream = null;
        }
        this.audioPlayer.destroy();
        if (this.loaded) {
            AL11.alSourceStop((int)this.source);
            AL11.alDeleteSources((int)this.source);
            ArrayList<Integer> bffs = new ArrayList<Integer>(this.buffers);
            bffs.forEach(AL10::alDeleteBuffers);
            this.buffers.clear();
        }
    }

    private int getPlayState() {
        return !this.loaded ? 4116 : AL11.alGetSourcei((int)this.source, (int)4112);
    }

    @Override
    public void pause() {
        if (this.getPlayState() == 4114) {
            this.lastPausedTime = System.currentTimeMillis();
            AL11.alSourcePause((int)this.source);
        }
    }

    @Override
    public void unpause() {
        if (this.getPlayState() == 4115) {
            this.lastPausedTime = 0L;
            AL11.alSourcePlay((int)this.source);
        }
    }

    @Override
    public boolean isPlaying() {
        return this.getPlayState() == 4114;
    }

    @Override
    public boolean isPaused() {
        return this.getPlayState() == 4115;
    }

    @Override
    public boolean isFinished() {
        return this.getPlayState() == 4116;
    }

    @Override
    public void setCoordinatePosition(Vec3 vec3) {
        if (vec3 == null) {
            vec3 = LavaALMusicPlayer.mc.f_91074_ != null ? LavaALMusicPlayer.mc.f_91074_.m_20182_() : Vec3.f_82478_;
        }
        this.pos = vec3;
        AL11.alSource3f((int)this.source, (int)4100, (float)((float)vec3.f_82479_), (float)((float)vec3.f_82480_), (float)((float)vec3.f_82481_));
    }

    @Override
    public Vec3 getCoordinatePosition() {
        return this.pos;
    }

    @Override
    public void setVolume(double v) {
        if (this.spatial) {
            AL11.alSourcef((int)this.source, (int)4106, (float)((float)v));
        } else {
            this.noSpatialVolume = v;
        }
    }

    @Override
    public void setRange(float r) {
        this.range = r;
        if (!this.fixed) {
            this.linearAttenuation(this.range);
        } else {
            AL11.alSourcei((int)this.source, (int)53248, (int)0);
        }
    }

    @Override
    public void update(MusicPlaybackInfo playbackInf) {
        if (this.isPaused()) {
            this.pausedTime += System.currentTimeMillis() - this.lastPausedTime;
            this.lastPausedTime = System.currentTimeMillis();
        }
        if (!this.spatial) {
            AL11.alSourcef((int)this.source, (int)4106, (float)((float)SoundMath.calculatePseudoAttenuation(this.pos, this.range, this.noSpatialVolume)));
        }
        if (this.getPosition() - this.lastLavaLoad >= 20000L && this.loadThread == null) {
            this.lastLavaLoad = this.getPosition();
            this.loadThread = new LavaLoadThread();
            this.loadThread.start();
        }
    }

    @Override
    public long getPosition() {
        return this.firstStart ? System.currentTimeMillis() - this.startTime + this.startPosition - this.pausedTime : this.startPosition;
    }

    @Override
    public MusicSource getMusicSource() {
        return this.musicSource;
    }

    @Override
    public void setFixedSound(boolean enable) {
        boolean flg = this.fixed != enable;
        this.fixed = enable;
        if (flg) {
            if (enable) {
                AL11.alSourcei((int)this.source, (int)53248, (int)0);
            } else {
                this.linearAttenuation(this.range);
            }
        }
    }

    private void linearAttenuation(float r) {
        AL11.alSourcei((int)this.source, (int)53248, (int)53251);
        AL11.alSourcef((int)this.source, (int)4131, (float)r);
        AL11.alSourcef((int)this.source, (int)4129, (float)1.0f);
        AL11.alSourcef((int)this.source, (int)4128, (float)0.0f);
    }

    private static void checkError() {
        switch (AL11.alGetError()) {
            case 0: {
                break;
            }
            case 40961: {
                throw new IllegalStateException("Invalid name parameter.");
            }
            case 40962: {
                throw new IllegalStateException("Invalid enumerated parameter value.");
            }
            case 40963: {
                throw new IllegalStateException("Invalid parameter parameter value.");
            }
            case 40964: {
                throw new IllegalStateException("Invalid operation.");
            }
            case 40965: {
                throw new IllegalStateException("Unable to allocate memory.");
            }
        }
    }

    private ByteBuffer getBuffer(byte[] array) {
        ByteBuffer audioBuffer2 = BufferUtils.createByteBuffer((int)array.length);
        audioBuffer2.put(array);
        audioBuffer2.flip();
        return audioBuffer2;
    }

    private int audioFormatToOpenAl(AudioFormat audioFormat) {
        AudioFormat.Encoding encoding = audioFormat.getEncoding();
        int j = audioFormat.getSampleSizeInBits();
        if (encoding.equals(AudioFormat.Encoding.PCM_UNSIGNED) || encoding.equals(AudioFormat.Encoding.PCM_SIGNED)) {
            return LavaALMusicPlayer.getOpenALFormat(this.spatial ? 1 : 2, j);
        }
        throw new IllegalArgumentException("Invalid audio format: " + audioFormat);
    }

    private static int getOpenALFormat(int channel, int bit) {
        if (channel == 1) {
            if (bit == 8) {
                return 4352;
            }
            if (bit == 16) {
                return 4353;
            }
        } else if (channel == 2) {
            if (bit == 8) {
                return 4354;
            }
            if (bit == 16) {
                return 4355;
            }
        }
        return 4353;
    }

    private synchronized void lavaLoad(AudioFormat format) {
        int b = AL11.alGenBuffers();
        int formatId = this.audioFormatToOpenAl(format);
        AL11.alBufferData((int)b, (int)formatId, (ByteBuffer)this.getBuffer(this.buffer), (int)((int)format.getSampleRate() * (this.spatial ? 2 : 1)));
        AL11.alSourceQueueBuffers((int)this.source, (int)b);
        this.buffers.add(b);
    }

    private class LavaLoadThread
    extends FlagThread {
        private LavaLoadThread() {
            this.setName("LavaPlayer Load Thread : " + LavaALMusicPlayer.this.musicSource.getIdentifier());
        }

        @Override
        public void run() {
            if (this.isStopped()) {
                return;
            }
            try {
                AudioFormat format = AudioDataFormatTools.toAudioFormat(LavaALMusicPlayer.this.audioFormat);
                if (this.isStopped()) {
                    return;
                }
                for (int i = 0; i < 3000; ++i) {
                    try {
                        if (LavaALMusicPlayer.this.stream.read(LavaALMusicPlayer.this.buffer) < 0 || this.isInterrupted()) break;
                        LavaALMusicPlayer.this.lavaLoad(format);
                    }
                    catch (Exception ex) {
                        break;
                    }
                    if (!this.isStopped()) continue;
                    return;
                }
                if (this.isStopped()) {
                    return;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            LavaALMusicPlayer.this.loadThread = null;
        }
    }
}

